<?php
/* --------------------------------------------------------------
   SqlFilter.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Criteria;

/**
 * Interface SqlFilter
 *
 * @package Gambio\Core\SqlCriteria\Interfaces
 */
interface SqlFilter
{
    /**
     * Returns the column name.
     *
     * @return string
     */
    public function column(): string;
    
    
    /**
     * Returns the required value, based on the operation.
     *
     * @return string
     */
    public function value(): string;
    
    
    /**
     * Returns the operation.
     *
     * @return string
     */
    public function operation(): string;
}